/**
* \file: GstreamerCommon.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: Veeraiyan Chidambaram /RBEI/ECF3/ veeraiyan.chidambaram@in.bosch.com
*          J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_GSTREAMERVIDEOPIPELINE_H
#define AAUTO_GSTREAMERVIDEOPIPELINE_H

#include <atomic>
#include <mutex>
#include "aauto/AditVideoSink.h"
#include <uspi/EndpointDataSharing.h>
#include <gst/gst.h>
#include <gst/app/gstappsrc.h>
#include <aauto_macros.h>
#include <time.h>
#include <sys/prctl.h>
#include "timer_utils.h"
#include <string.h>
#include <queue>

#define VIDEO_MAX_QUEUE_SIZE    100000


namespace adit { namespace aauto
{

const uint64_t NS_TO_MS = 1000 * 1000;
const uint64_t MS_TO_S = 1000;

const uint64_t OUT_BUS_STOP_DEFAULT_MILLI = 500;
const uint64_t ONE_MILLI_IN_NANO = 1000 * 1000;
const uint64_t ONE_SEC_IN_NANO = 1000 * 1000 * 1000;


enum GstreamerChannelNames
{
    GstreamerChannelName_Invalid = 0,
    GstreamerChannelName_VideoOut = 1,
};

extern const char* GstreamerChannelNameStrings[];

void MessageBusAddRef();
void MessageBusUnref();

class GstreamerVideoPipeline
{
public:
    GstBus* bus;
    GSource* source;
    GstElement* partial;
    GstElement* appsrc;
    GstElement* gstVideoSink;
    int64_t eosTimeOutNano;
    GstreamerChannelNames channelName;
    guint watchId;
    pthread_cond_t stopCondition;
    pthread_mutex_t stopConditionMutex;
    bool stopped;
    bool setThreadPrio;
    uint32_t threadPrio;
    
    GstElement* pipeline;
    unsigned long enoughDataHandlerId;
    unsigned long firstFrameRenderedHandlerId;
    std::atomic_bool running;
    bool firstFrame;
    bool firstFrameRendered;
    uint64_t prepareTimeStamp;
    
    std::string wlHandleName;
    struct wl_display* display;
    void* mSessionContext;

    GstreamerVideoPipeline(IAditVideoSinkCallbacks* inCallbacks, void* inSessionContext);
    ~GstreamerVideoPipeline();

    int SetThreadPriority(const char* threadName, uint32_t priority);
    
    bool GstreamerStart(std::string videoPipeline, int32_t gwidth, int32_t gheight);
    void GstreamerStop();
    void GstreamerPush(uint64_t inTimestamp, uint8_t* inDataPtr, size_t inLen);

private:

    static void firstFrameRenderedHandler(GstElement * element, GstPad *pad, gpointer user_data);
    static void enoughDataHandler(GstElement* inPipeline, GstreamerVideoPipeline* inMe);


    bool CreatePipeline(const std::string& inName, const std::string& inLaunch,
            GstreamerChannelNames inChannelName);
    void StopPipeline();

    bool CreateAppSrc(const std::string& inName, int32_t gwidth, int32_t gheight, uint64_t maxBytes);
    bool CreateVideoSink();

    bool SendAndWaitForEOS();

    bool PrepareAndWaitForPushing();

    IAditVideoSinkCallbacks* mCallbacks;
};

gboolean busCallBack(GstBus* inBus, GstMessage* inMessage, gpointer inPointer);

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_GSTREAMERVIDEOPIPELINE_H */
